<!doctype html>
<!--[if IE 8]>
<html {languageAttributes}  class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass} ie ie8">
<![endif]-->
<!--[if !(IE 7) | !(IE 8)]><!-->
<html {languageAttributes} class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass}">
<!--<![endif]-->
<head>
	<meta charset="{$wp->charset}">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="{$wp->pingbackUrl}">
	{if $options->theme->general->favicon != ""}
		<link href="{$options->theme->general->favicon}" rel="icon" type="image/x-icon" />
	{/if}

	{includePart parts/seo}

	{googleAnalytics $options->theme->google->analyticsTrackingId, $options->theme->google->anonymizeIp}

	{!$options->theme->header->customJsCode}

	{wpHead}
</head>
<body {!$wp->bodyHtmlClass}>
	{* usefull for inline scripts like facebook social plugins scripts, etc... *}
	{doAction ait-html-body-begin}

	<div id="page" class="hfeed page-container">

		{var $menuClass = $options->layout->general->menuOverVideo && $elements->unsortable[header-video]->display || $options->layout->general->menuOverVideo && $elements->unsortable[revolution-slider]->display ? 'header-over' : 'header-before'}
		{var $defaultHeader = $options->layout->general->menuOverVideo && $elements->unsortable[header-video]->display || $options->layout->general->menuOverVideo && $elements->unsortable[revolution-slider]->display ? 'header-over' : 'header-before'}

		{if $options->theme->header->headerType == 'headerSix'}
			<header id="masthead" class="site-header {$menuClass}" role="banner" data-defaultHeader="{$defaultHeader}">

				{if $options->theme->header->topmenu6}
				<div class="header-top">
					<div class="grid-main">
						{menu header, depth => 1}
					</div>
				</div>
				{/if}

				<div class="header-container grid-main">
					{!$options->theme->header->customHtml}


					<div class="site-tools">
						{includePart parts/languages-switcher}
						<div class="ait-woocommerce-cart-widget">
							{includePart "parts/woocommerce-cart"}
						</div>
					</div>

					<div class="menu-container">
						<nav class="main-nav" role="navigation" data-max-width="{$options->theme->header->burgerMenuWidth}">
							<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
							<div class="main-nav-wrap">
								<h3 class="menu-toggle">{__ 'Menu'}</h3>
								{menu main}
							</div>
						</nav>
					</div>

				</div>


			</header><!-- #masthead -->
		{else}
			<header id="masthead" class="site-header {$menuClass}" role="banner" data-defaultHeader="{$defaultHeader}">

				{if $options->theme->header->topmenu1}
				<div class="header-top">
					<div class="grid-main">
						{menu header, depth => 1}
					</div>
				</div>
				{/if}

				<div class="header-container grid-main">
					<div class="site-logo">
						{if $options->theme->header->logo || $options->theme->header->stickylogo}
							{if $options->theme->header->logo}
								<a class="logo-main" href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
							{/if}
							{if $options->theme->header->stickylogo}
								<a class="logo-alternative" href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->stickylogo}" alt="logo"></a>
							{/if}
						{else}
							<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
						{/if}
						
						<p class="site-description">{$wp->description}</p>
					</div>
					

					<div class="site-tools">
						{includePart parts/languages-switcher}
						<div class="ait-woocommerce-cart-widget">
							{includePart "parts/woocommerce-cart"}
						</div>
					</div>

					<div class="menu-container">
						<nav class="main-nav" role="navigation" data-max-width="{$options->theme->header->burgerMenuWidth}">
							<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a>
							<div class="main-nav-wrap">
								<h3 class="menu-toggle">{__ 'Menu'}</h3>
								{menu main}
							</div>
						</nav>
					</div>

				</div>

			</header><!-- #masthead -->
		{/if}

		<div class="sticky-menu menu-container" >
			<div class="grid-main">
				<div class="site-logo">
					{if $options->theme->header->logo}
					<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->stickylogo}" alt="logo"></a>
					{else}
					<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
					{/if}
				</div>
				<nav class="main-nav">
					<!-- wp menu here -->
				</nav>
			</div>
		</div>
